// 
// Decompiled by Procyon v0.5.36
// 

package ORG.oclc.oai.harvester.verb;

import java.util.Map;
import ORG.oclc.oai.util.OAIUtil;
import org.xml.sax.Attributes;
import java.util.Iterator;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.io.IOException;
import java.net.MalformedURLException;
import org.xml.sax.XMLReader;
import org.xml.sax.SAXException;
import org.xml.sax.InputSource;
import org.xml.sax.ContentHandler;
import java.net.URL;
import java.util.HashMap;
import java.util.ArrayList;

public class GetRecord extends HarvesterVerb
{
    private static final boolean debug = false;
    private boolean recordCapture;
    private StringBuffer record;
    private ArrayList records;
    private HashMap xmlnsMap;
    
    public GetRecord(final URL baseURL, final String identifier, final String metadataPrefix) throws MalformedURLException, SAXException, IOException {
        this.recordCapture = false;
        this.record = new StringBuffer();
        this.records = new ArrayList();
        this.xmlnsMap = new HashMap();
        final StringBuffer query = new StringBuffer();
        query.append(baseURL.toString());
        query.append("?");
        query.append(getParams(identifier, metadataPrefix));
        final XMLReader xmlReader = this.getXMLReader();
        xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        xmlReader.setContentHandler(this);
        try {
            xmlReader.parse(new InputSource(this.getResponseStream(query.toString())));
        }
        catch (SAXException e) {
            System.out.println("HarvesterVerb.HarvesterVerb: query=" + (Object)query);
            e.printStackTrace();
            throw e;
        }
    }
    
    private static String getParams(final String identifier, final String metadataPrefix) throws IOException {
        try {
            final StringBuffer query = new StringBuffer();
            query.append("verb=GetRecord");
            query.append("&identifier=");
            query.append(URLEncoder.encode(identifier, "UTF-8"));
            query.append("&metadataPrefix=");
            query.append(URLEncoder.encode(metadataPrefix, "UTF-8"));
            return query.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }
    
    public Iterator iterator() {
        return this.records.iterator();
    }
    
    public String toString() {
        final StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        return sb.toString();
    }
    
    public void startElement(final String namespaceURI, final String localName, final String qName, final Attributes attrs) {
        final String fullName = HarvesterVerb.fullName(namespaceURI, localName);
        if (!this.recordCapture && fullName.equals(HarvesterVerb.OAI20_RECORD)) {
            this.record.setLength(0);
            this.recordCapture = true;
        }
        final int length = attrs.getLength();
        if (this.recordCapture) {
            this.record.append("<");
            this.record.append(qName);
            for (int i = 0; i < length; ++i) {
                this.record.append(" ");
                final String aEName = attrs.getQName(i);
                this.record.append(aEName);
                this.record.append("=\"");
                this.record.append(OAIUtil.xmlEncode(attrs.getValue(i)));
                this.record.append("\"");
                if (aEName.startsWith("xmlns:")) {
                    this.xmlnsMap.remove(aEName);
                }
            }
            if (fullName.equals(HarvesterVerb.OAI20_RECORD)) {
                for (final Map.Entry entry : this.xmlnsMap.entrySet()) {
                    this.record.append(" ").append(entry.getKey()).append("\"").append(OAIUtil.xmlEncode(entry.getValue())).append("\"");
                }
            }
            this.record.append(">");
        }
        else {
            for (int i = 0; i < length; ++i) {
                final String aEName = attrs.getQName(i);
                if (aEName.startsWith("xmlns:")) {
                    this.xmlnsMap.put(aEName, attrs.getValue(i));
                }
            }
            super.startElement(namespaceURI, localName, qName, attrs);
        }
    }
    
    public void endElement(final String namespaceURI, final String localName, final String qName) throws SAXException {
        final String fullName = HarvesterVerb.fullName(namespaceURI, localName);
        if (this.recordCapture) {
            this.record.append("</");
            this.record.append(qName);
            this.record.append(">");
        }
        else {
            super.endElement(namespaceURI, localName, qName);
        }
        if (fullName.equals(HarvesterVerb.OAI20_RECORD)) {
            try {
                this.records.add(new Record(this.record.toString()));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new SAXException(e.getMessage());
            }
            this.recordCapture = false;
        }
    }
    
    public void characters(final char[] buf, final int offset, final int len) {
        if (this.recordCapture) {
            this.record.append(OAIUtil.xmlEncode(new String(buf, offset, len)));
        }
        else {
            super.characters(buf, offset, len);
        }
    }
}
